/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.system.dao.MCodeDao;
import jp.mosp.system.dto.MCodeDto;
import jp.mosp.system.vo.YukyuInformationCardVo;

public class YukyuInformationCardAction extends MosPAction {

	//R}h
	private static final String CMD_YUKYU_INFO_SHOW 		= "S2700";	//\
	private static final String CMD_YUKYU_INFO_UPDATE		= "S2708";	//XV

	/**
	 * RXgN^
	 */
	public YukyuInformationCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// VXemF
		confirmSystemAuth();
		// VO̎擾yѐݒ
		YukyuInformationCardVo vo = new YukyuInformationCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[h̏
		setVo(vo);
		setUrl(vo.getRetUrl());
		// v_EXg쐬
		vo.aryPltCFKbn = getPltCFKbnArray();
		vo.aryPltCFMonth = util.getMonthArray();
		// DTO̎擾
		MCodeDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MCodeDto ? (MCodeDto)obj : null;
		// R}h̏
		if (cmd.equals(CMD_YUKYU_INFO_SHOW)) {
			// \
			show(vo, dto);
			// [hݒ
			setMode(vo);			
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_YUKYU_INFO_UPDATE)){
			// JzXVAXV
			regist(vo, dto);
			// R~bg
			commit();			
			// \
			show(vo, dto);
			// [hݒ
			setMode(vo);
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * ݒ荀ڌ
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	private void show(YukyuInformationCardVo vo, MCodeDto dto) throws Exception {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// Jz
		vo.setFieldsCFMonth(dao.findForKey(CommonConst.NAM_PAID_HOLIDAY,
				CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_MONTH)
		);		
		// Jz
		vo.setFieldsCFDay(dao.findForKey(CommonConst.NAM_PAID_HOLIDAY,
				CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_NUMBER_OF_DAYS)
		);
		// Jz敪
		vo.setFieldsCFDivision(dao.findForKey(CommonConst.NAM_PAID_HOLIDAY, 
				CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_COMMON_TYPE)
		);
		// LxɎx	
		vo.setDefaultValues();
		vo.setFields(dao.findForHoliday(CommonConst.NAM_PAID_HOLIDAY + CommonConst.NAM_SUPPLY));		
	}

	/**
	 * f[^XViJzځj
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @throws Exception
	 */
	private void regist(YukyuInformationCardVo vo, MCodeDto dto) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		if (dto == null) {
			dto = new MCodeDto();
		}
		// Jz
		vo.setDtoFieldsCFMonth(dto);
		update(vo, dto);
		// Jz
		vo.setDtoFieldsCFDay(dto);
		update(vo, dto);
		// Jz敪
		vo.setDtoFieldsCFDivision(dto);	
		update(vo, dto);
		// f[^XV(x)
		update(vo);
	}

	/**
	 * f[^XViJzj
	 * @param vo
	 * @param dto
	 * @throws Exception
	 */
	private void update(YukyuInformationCardVo vo, MCodeDto dto) throws Exception {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTO̍Ď擾
		MCodeDto retDto;
		// rmF
		chkExclusive(dao.findForKey(dto.getTId(), dto.getTCode()), dao.findForUpdate(dto.getTId(), dto.getTCode()), vo);
		// f[^̍XV
		dao.update(dto);
		// Abvf[g̃`FbN
		retDto = dao.findForKey(dto.getTId(), dto.getTCode());
		chkUpdate(retDto);
	}

	/**
	 * f[^XV(x)
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void update(YukyuInformationCardVo vo) throws Exception {
		// DAȌ
		MCodeDao dao = new MCodeDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// XVO
		// e[ubN
		dao.tableLock(CommonConst.NAM_PAID_HOLIDAY + CommonConst.NAM_SUPPLY);
		// 폜
		dao.delete(CommonConst.NAM_PAID_HOLIDAY + CommonConst.NAM_SUPPLY);	
		// DTȌ
		List<MCodeDto> listCode = new ArrayList<MCodeDto>(20);
		vo.setDtoFields(listCode);
		for (int i = 0; i < listCode.size(); i++) {
			MCodeDto dto = listCode.get(i);
			if (dto.getTCode().equals("")) {
				continue;
			}
			// dmF
			chkDuplicate(dao.findForKey(dto.getTId(), dto.getTCode()), vo);
			// o^
			dao.insert(dto);
			// DTO̍Ď擾
			MCodeDto retDto = dao.findForKey(dto.getTId(), dto.getTCode());
			chkInsert(retDto);
		}
	}

	/**
	 * [hݒ
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void setMode(YukyuInformationCardVo vo) throws Exception {
		// [hݒ
		vo.setMode(YukyuInformationCardVo.MODE_UPDATE);
	}

	/**
	 * Jz敪
	 * @return Jz敪z
	 */
	private String[][] getPltCFKbnArray() {
		// z̍쐬
		String[][] aryPosition = new String[2][2];
		for (int i = 0; i < aryPosition.length; i++) {
			if (i == 0) {
				aryPosition[i][0] = String.valueOf(i);
				aryPosition[i][1] = CommonConst.NAM_CARRY_OVER_THIS_YEAR;
			} else {
				aryPosition[i][0] =  String.valueOf(i);
				aryPosition[i][1] = CommonConst.NAM_CARRY_OVER_TOTAL;
			}
		}
		return aryPosition;
	}

}
